<?php
define('BASEPATH', 'dummy'); // Bypass check
// Load Config
$config = [];
include 'application/config/rajaongkir.php';
$api_key = $config['rajaongkir_api_key'];

// Endpoint Province Komerce
$url = 'https://rajaongkir.komerce.id/api/v1/destination/province';

$curl = curl_init();

$options = array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => array('key: ' . $api_key),
);

curl_setopt_array($curl, $options);
$response = curl_exec($curl);
curl_close($curl);
$decoded = json_decode($response, true);

if (isset($decoded['data'][0])) {
    $first_prov = $decoded['data'][0];
    $prov_id = isset($first_prov['id']) ? $first_prov['id'] : 0;
    
    echo "\nTesting City for Province ID: $prov_id\n";
    $url_city = "https://rajaongkir.komerce.id/api/v1/destination/city?province_id=$prov_id";
    
    $curl = curl_init();
    $options[CURLOPT_URL] = $url_city;
    curl_setopt_array($curl, $options);
    $response_city = curl_exec($curl);
    curl_close($curl);
    
    echo "Raw City Response:\n";
    echo $response_city;
}
?>
