<?php
// Mock CI Environment
define('BASEPATH', 'system/');

class CI_Model {
    public function __construct() {}
    public function __get($key) {
        $CI =& get_instance();
        return $CI->$key;
    }
}
class CI_Controller {
    public static $instance;
    public function __construct() { self::$instance = $this; }
}

class MockConfig {
    public function item($key, $file) {
        if ($key == 'rajaongkir_api_key') return 'v1H0XuWX315aa941296cc75dpKNKTPhp';
        if ($key == 'rajaongkir_base_url') return 'https://api.rajaongkir.com/starter'; // Original default
        return null;
    }
    public function load($file, $arg=false) {}
}

class MockLoader {
    public function config($file, $arg=false) {}
    public function helper($file) {
        if ($file == 'indonesia_data') {
            require_once 'c:\xampp\htdocs\gerabah\customer\application\helpers\indonesia_data_helper.php';
        }
    }
}

function log_message($level, $msg) { echo "[$level] $msg\n"; }

// Instantiate
$ci = new CI_Controller();
$ci->config = new MockConfig();
$ci->load = new MockLoader();

function &get_instance() { return CI_Controller::$instance; }

// Include Model
require_once 'c:\xampp\htdocs\gerabah\customer\application\models\Mongkir.php';

$mongkir = new Mongkir();
echo "Testing get_all_provinsi() with MAPPING...\n";
$provinces = $mongkir->get_all_provinsi();

if (!empty($provinces)) {
    echo "Success! Retrieved " . count($provinces) . " provinces.\n";
    
    // Check specific provinces
    $targets = ['DKI JAKARTA', 'JAWA TENGAH', 'JAWA BARAT', 'BENGKULU'];
    foreach ($provinces as $p) {
        if (in_array(strtoupper($p['province']), $targets)) {
            echo "Found: " . $p['province'] . " -> ID: " . $p['province_id'] . "\n";
        }
    }
    
    echo "\nExpected Standard IDs:\n";
    echo "DKI JAKARTA: 6\n";
    echo "JAWA TENGAH: 10\n";
    echo "JAWA BARAT: 9\n";
    echo "BENGKULU: 4\n";
    
} else {
    echo "Failed to retrieve provinces.\n";
}
