<?php
// Mock CI Environment
define('BASEPATH', 'system/');

class CI_Model {
    public function __construct() {}
    public function __get($key) {
        $CI =& get_instance();
        return $CI->$key;
    }
}
class CI_Controller {
    public static $instance;
    public function __construct() { self::$instance = $this; }
}

class MockConfig {
    public function item($key, $file) {
        if ($key == 'rajaongkir_api_key') return 'v1H0XuWX315aa941296cc75dpKNKTPhp';
        if ($key == 'rajaongkir_base_url') return 'https://api.rajaongkir.com/starter'; // Original default
        return null;
    }
    public function load($file, $arg=false) {}
}

class MockLoader {
    public function config($file, $arg=false) {}
    public function helper($file) {
        if ($file == 'indonesia_data') {
            require_once 'c:\xampp\htdocs\gerabah\customer\application\helpers\indonesia_data_helper.php';
        }
    }
}

function log_message($level, $msg) { echo "[$level] $msg\n"; }

// Instantiate
$ci = new CI_Controller();
$ci->config = new MockConfig();
$ci->load = new MockLoader();

function &get_instance() { return CI_Controller::$instance; }

// Include Model
require_once 'c:\xampp\htdocs\gerabah\customer\application\models\Mongkir.php';

$mongkir = new Mongkir();
echo "Testing get_all_provinsi()...\n";
$provinces = $mongkir->get_all_provinsi();

if (!empty($provinces)) {
    echo "Success! Retrieved " . count($provinces) . " provinces.\n";
    echo "First item: \n";
    print_r($provinces[0]);
    
    // Check keys
    if (isset($provinces[0]['province_id']) && isset($provinces[0]['province'])) {
        echo "Keys match Standard RajaOngkir format.\n";
    } else {
        echo "FAIL: Keys do NOT match Standard RajaOngkir format.\n";
    }
} else {
    echo "Failed to retrieve provinces.\n";
}
