<?php
// Load CodeIgniter untuk test
define('BASEPATH', TRUE);
$_SERVER['CI_ENV'] = 'development';

// Manual bootstrap
require_once('../system/core/Common.php');
require_once('../application/config/database.php');

$conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$now = date('Y-m-d H:i:s');
echo "<h2>Test Produk dengan Promo</h2>";
echo "<p><strong>Waktu Sekarang:</strong> $now</p><hr>";

// Query produk yang ada di promo_produk
$sql = "SELECT 
    p.id_produk,
    p.nama_produk,
    p.harga_produk,
    pp.harga_diskon as harga_diskon_pp,
    pr.id_promo,
    pr.nama_promo,
    pr.status_promo,
    pr.waktu_mulai,
    pr.waktu_berakhir,
    pr.tipe_diskon,
    pr.nilai_diskon
FROM produk p
INNER JOIN promo_produk pp ON pp.id_produk = p.id_produk
INNER JOIN promo pr ON pr.id_promo = pp.id_promo
ORDER BY p.id_produk DESC";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<h3>Produk yang Terdaftar di Promo:</h3>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr style='background: #1a1f3a; color: white;'>
            <th>Nama Produk</th>
            <th>Harga Normal</th>
            <th>Harga Diskon</th>
            <th>Nama Promo</th>
            <th>Status</th>
            <th>Mulai</th>
            <th>Berakhir</th>
            <th>Aktif?</th>
          </tr>";
    
    while($row = $result->fetch_assoc()) {
        $waktu_mulai = strtotime($row['waktu_mulai']);
        $waktu_berakhir = strtotime($row['waktu_berakhir']);
        $waktu_sekarang = strtotime($now);
        
        $is_active = ($row['status_promo'] == 'aktif' && $waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang);
        $bg_color = $is_active ? '#d4edda' : '#f8d7da';
        
        echo "<tr style='background: $bg_color;'>";
        echo "<td><strong>" . htmlspecialchars($row['nama_produk']) . "</strong></td>";
        echo "<td>Rp " . number_format($row['harga_produk'], 0, ',', '.') . "</td>";
        echo "<td>Rp " . number_format($row['harga_diskon_pp'], 0, ',', '.') . "</td>";
        echo "<td>" . htmlspecialchars($row['nama_promo']) . "</td>";
        echo "<td>" . $row['status_promo'] . "</td>";
        echo "<td>" . $row['waktu_mulai'] . "</td>";
        echo "<td>" . $row['waktu_berakhir'] . "</td>";
        echo "<td style='font-weight: bold; " . ($is_active ? "color: green;" : "color: red;") . "'>" . ($is_active ? 'YA ✓' : 'TIDAK ✗') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ TIDAK ADA PRODUK YANG TERDAFTAR DI PROMO!</p>";
    echo "<p>Silakan tambahkan produk ke promo di halaman admin.</p>";
}

$conn->close();
?>

