<?php
/**
 * Test Script untuk Raja Ongkir API
 * 
 * Cara menggunakan:
 * 1. Buka browser
 * 2. Akses: http://localhost/marketplace1/customer/test_rajaongkir.php
 * 3. Lihat hasil test
 */

// If you run this file directly, it will attempt to read CI config file for RajaOngkir.
// Try to include application config if possible
// NOTE: do not expose API keys publicly in production.
// Attempt to read config from application/config/rajaongkir.php
if (!defined('BASEPATH')) define('BASEPATH', 'TEST');
$config_path = __DIR__ . '/application/config/rajaongkir.php';
$api_key = '';
$base_url = 'https://api.rajaongkir.com/starter';
if (file_exists($config_path)) {
    // include and capture $config array
    $config = array();
    include $config_path;
    if (isset($config['rajaongkir_api_key'])) $api_key = $config['rajaongkir_api_key'];
    if (isset($config['rajaongkir_base_url'])) $base_url = $config['rajaongkir_base_url'];
}

// Fallback: allow manual override via querystring ?key=YOUR_KEY
if (isset($_GET['key']) && !empty($_GET['key'])) {
    $api_key = $_GET['key'];
}

echo "<h2>Test Raja Ongkir API</h2>";
echo "<hr>";

// Test 1: Cek API Key
echo "<h3>1. API Key Configuration</h3>";
echo "API Key: " . (!empty($api_key) ? substr($api_key, 0, 10) . '...' : '<span style="color:red">(kosong)</span>') . "<br>";
echo "Base URL: " . $base_url . "<br>";
echo "<br>";

// Test 2: Test Connection
echo "<h3>2. Test Connection ke Raja Ongkir</h3>";
$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => $base_url . '/province',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => array(
        'key: ' . $api_key
    ),
));

$response = curl_exec($curl);
$curl_error = curl_error($curl);
$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

echo "HTTP Code: <strong>" . $http_code . "</strong><br>";

if($curl_error) {
    echo "CURL Error: <span style='color:red;'>" . $curl_error . "</span><br>";
} else {
    echo "CURL Error: <span style='color:green;'>None</span><br>";
}

echo "<br>";

// Test 3: Parse Response
echo "<h3>3. Response dari API</h3>";
$result = json_decode($response, true);

if($http_code == 200) {
    if(isset($result['rajaongkir']['results']) && is_array($result['rajaongkir']['results'])) {
        echo "<span style='color:green;'><strong>SUCCESS!</strong></span><br>";
        echo "Jumlah Provinsi: <strong>" . count($result['rajaongkir']['results']) . "</strong><br><br>";
        
        echo "Daftar 5 Provinsi Pertama:<br>";
        echo "<ul>";
        $count = 0;
        foreach($result['rajaongkir']['results'] as $prov) {
            if($count < 5) {
                echo "<li>" . $prov['province'] . " (ID: " . $prov['province_id'] . ")</li>";
                $count++;
            }
        }
        echo "</ul>";
    } else {
        echo "<span style='color:red;'><strong>ERROR:</strong> Response tidak valid</span><br>";
        echo "Response: <pre>" . htmlspecialchars($response) . "</pre>";
    }
} else if($http_code == 401) {
    echo "<span style='color:red;'><strong>ERROR 401:</strong> API Key tidak valid atau tidak terdaftar</span><br>";
    echo "Response: <pre>" . htmlspecialchars($response) . "</pre>";
} else if($http_code == 403) {
    echo "<span style='color:red;'><strong>ERROR 403:</strong> Akses ditolak</span><br>";
    echo "Response: <pre>" . htmlspecialchars($response) . "</pre>";
} else {
    echo "<span style='color:red;'><strong>ERROR " . $http_code . ":</strong> Terjadi kesalahan</span><br>";
    echo "Response: <pre>" . htmlspecialchars($response) . "</pre>";
}

echo "<hr>";
echo "<p><strong>Catatan:</strong> Setelah test selesai, hapus file ini untuk keamanan.</p>";
?>

