<!DOCTYPE html>
<html>
<head>
    <title>Test Simple Query</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background: #1a1f3a; color: white; }
        .has-promo { background: #d4edda; }
        .no-promo { background: #f8d7da; }
    </style>
</head>
<body>
    <h1>Test Query Produk dengan Promo</h1>
    <p><strong>Waktu Sekarang:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>
    
    <?php
    $conn = new mysqli('localhost', 'root', '', 'gerabah');
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    $now = date('Y-m-d H:i:s');
    
    // Query yang sama dengan model
    $sql = "SELECT 
        produk.*, 
        kategori.nama_kategori, 
        promo_produk.harga_diskon, 
        promo.status_promo, 
        promo.waktu_mulai, 
        promo.waktu_berakhir, 
        promo.tipe_diskon, 
        promo.nilai_diskon,
        promo.nama_promo
    FROM produk
    LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
    LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
    LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
    ORDER BY produk.id_produk DESC
    LIMIT 10";
    
    $result = $conn->query($sql);
    
    if ($result && $result->num_rows > 0) {
        echo "<table>";
        echo "<tr>
            <th>Produk</th>
            <th>Harga Normal</th>
            <th>Harga Diskon (DB)</th>
            <th>Promo</th>
            <th>Status</th>
            <th>Waktu Mulai</th>
            <th>Waktu Berakhir</th>
            <th>Promo Valid?</th>
            <th>Seharusnya Tampil?</th>
        </tr>";
        
        while($row = $result->fetch_assoc()) {
            $has_promo_data = !is_null($row['harga_diskon']) && $row['harga_diskon'] > 0;
            
            $promo_valid = false;
            $alasan = "";
            
            if($has_promo_data) {
                if($row['status_promo'] == 'aktif') {
                    $waktu_mulai = strtotime($row['waktu_mulai']);
                    $waktu_berakhir = strtotime($row['waktu_berakhir']);
                    $waktu_sekarang = strtotime($now);
                    
                    if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                        $promo_valid = true;
                        $alasan = "✓ AKTIF";
                    } else {
                        if($waktu_mulai > $waktu_sekarang) {
                            $alasan = "Belum dimulai";
                        } else {
                            $alasan = "Sudah berakhir";
                        }
                    }
                } else {
                    $alasan = "Status: " . $row['status_promo'];
                }
            } else {
                $alasan = "Tidak ada data promo";
            }
            
            $class = $promo_valid ? 'has-promo' : 'no-promo';
            
            echo "<tr class='{$class}'>";
            echo "<td><strong>{$row['nama_produk']}</strong></td>";
            echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
            echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0) : '-') . "</td>";
            echo "<td>" . ($row['nama_promo'] ? $row['nama_promo'] : '-') . "</td>";
            echo "<td>" . ($row['status_promo'] ? $row['status_promo'] : '-') . "</td>";
            echo "<td>" . ($row['waktu_mulai'] ? $row['waktu_mulai'] : '-') . "</td>";
            echo "<td>" . ($row['waktu_berakhir'] ? $row['waktu_berakhir'] : '-') . "</td>";
            echo "<td><strong style='color: " . ($promo_valid ? 'green' : 'red') . ";'>{$alasan}</strong></td>";
            echo "<td><strong style='color: " . ($promo_valid ? 'green' : 'red') . ";'>" . ($promo_valid ? 'YA ✓' : 'TIDAK ✗') . "</strong></td>";
            echo "</tr>";
        }
        
        echo "</table>";
        
        // Hitung berapa yang valid
        $result->data_seek(0);
        $count_valid = 0;
        while($row = $result->fetch_assoc()) {
            if(!is_null($row['harga_diskon']) && $row['harga_diskon'] > 0 && $row['status_promo'] == 'aktif') {
                $waktu_mulai = strtotime($row['waktu_mulai']);
                $waktu_berakhir = strtotime($row['waktu_berakhir']);
                $waktu_sekarang = strtotime($now);
                if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                    $count_valid++;
                }
            }
        }
        
        echo "<p style='font-size: 18px; margin-top: 20px;'>";
        echo "<strong>Produk dengan promo VALID yang seharusnya tampil: {$count_valid}</strong>";
        echo "</p>";
        
        if($count_valid == 0) {
            echo "<div style='background: #f8d7da; padding: 20px; border-radius: 5px; margin-top: 20px;'>";
            echo "<h3>❌ Tidak ada produk dengan promo aktif!</h3>";
            echo "<p><strong>Kemungkinan masalah:</strong></p>";
            echo "<ol>";
            echo "<li>Status promo bukan 'aktif' (mungkin 'tidak_aktif' atau lainnya)</li>";
            echo "<li>Waktu promo belum dimulai atau sudah berakhir</li>";
            echo "<li>Produk belum ditambahkan ke promo</li>";
            echo "</ol>";
            echo "<p><a href='../admin/promo' style='background: #1a1f3a; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>Ke Halaman Admin Promo</a></p>";
            echo "</div>";
        }
        
    } else {
        echo "<p>Tidak ada produk</p>";
    }
    
    $conn->close();
    ?>
    
    <p style="margin-top: 30px;">
        <a href="../customer" style="background: #1a1f3a; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">← Kembali ke Customer</a>
        <a href="cek_promo.php" style="background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-left: 10px;">Cek Status Promo</a>
    </p>
</body>
</html>

