<?php
// Simulate CI Controller environment partially to check for syntax/runtime errors
define('BASEPATH', 'mock');
define('CI_VERSION', '3.1.11');

// Mock classes
class CI_Controller {
    public function __construct() {}
}

class CI_Model {
    public function __construct() {}
}

// Check Notifikasi.php
include 'c:\xampp\htdocs\gerabah\admin\application\controllers\Notifikasi.php';
echo "Notifikasi.php syntax OK\n";

// Check Mnotifikasi.php
include 'c:\xampp\htdocs\gerabah\admin\application\models\Mnotifikasi.php';
echo "Mnotifikasi.php syntax OK\n";

// Test date logic
$controller = new Notifikasi();
// We can't call get_latest because it uses $this->Mnotifikasi which isn't initialized in this mock
// But we can check time_elapsed_string logic if we expose it (it is private)

$reflection = new ReflectionClass('Notifikasi');
$method = $reflection->getMethod('time_elapsed_string');
$method->setAccessible(true);

try {
    $time = date('Y-m-d H:i:s', strtotime('-2 hours'));
    echo "Time ago for $time: " . $method->invoke($controller, $time) . "\n";
} catch (Exception $e) {
    echo "Date Error: " . $e->getMessage() . "\n";
}
?>