<?php
// Debug script untuk cek promo
require_once('admin/application/config/database.php');

$conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Debug Promo</h2>";
echo "<p><strong>Waktu Server Sekarang:</strong> " . date('Y-m-d H:i:s') . "</p><hr>";

// Ambil data promo
$sql = "SELECT * FROM promo ORDER BY id_promo DESC";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        echo "<h3>Promo: " . $row['nama_promo'] . "</h3>";
        echo "<p>ID Promo: " . $row['id_promo'] . "</p>";
        echo "<p>Status: " . $row['status_promo'] . "</p>";
        echo "<p>Waktu Mulai: " . $row['waktu_mulai'] . "</p>";
        echo "<p>Waktu Berakhir: " . $row['waktu_berakhir'] . "</p>";
        echo "<p>Tipe Diskon: " . $row['tipe_diskon'] . "</p>";
        echo "<p>Nilai Diskon: " . $row['nilai_diskon'] . "</p>";
        
        $now = date('Y-m-d H:i:s');
        $waktu_mulai = strtotime($row['waktu_mulai']);
        $waktu_berakhir = strtotime($row['waktu_berakhir']);
        $waktu_sekarang = strtotime($now);
        
        echo "<p><strong>Perbandingan:</strong></p>";
        echo "<ul>";
        echo "<li>Waktu Mulai (timestamp): " . $waktu_mulai . " = " . date('Y-m-d H:i:s', $waktu_mulai) . "</li>";
        echo "<li>Waktu Sekarang (timestamp): " . $waktu_sekarang . " = " . date('Y-m-d H:i:s', $waktu_sekarang) . "</li>";
        echo "<li>Waktu Berakhir (timestamp): " . $waktu_berakhir . " = " . date('Y-m-d H:i:s', $waktu_berakhir) . "</li>";
        echo "</ul>";
        
        if ($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang && $row['status_promo'] == 'aktif') {
            echo "<p style='color: green; font-weight: bold;'>✅ PROMO AKTIF</p>";
        } else {
            echo "<p style='color: red; font-weight: bold;'>❌ PROMO TIDAK AKTIF</p>";
            if ($waktu_mulai > $waktu_sekarang) {
                echo "<p>Alasan: Belum dimulai (mulai " . ($waktu_mulai - $waktu_sekarang) . " detik lagi)</p>";
            } elseif ($waktu_berakhir < $waktu_sekarang) {
                echo "<p>Alasan: Sudah berakhir (" . ($waktu_sekarang - $waktu_berakhir) . " detik yang lalu)</p>";
            } elseif ($row['status_promo'] != 'aktif') {
                echo "<p>Alasan: Status promo = " . $row['status_promo'] . " (bukan 'aktif')</p>";
            }
        }
        
        // Cek produk di promo
        $sql_produk = "SELECT pp.*, p.nama_produk, p.harga_produk 
                       FROM promo_produk pp 
                       LEFT JOIN produk p ON p.id_produk = pp.id_produk 
                       WHERE pp.id_promo = " . $row['id_promo'];
        $result_produk = $conn->query($sql_produk);
        
        if ($result_produk->num_rows > 0) {
            echo "<p><strong>Produk dalam promo ini:</strong></p>";
            echo "<ul>";
            while($produk = $result_produk->fetch_assoc()) {
                echo "<li>" . $produk['nama_produk'] . " - Harga Awal: Rp " . number_format($produk['harga_awal'], 0, ',', '.') . " - Harga Diskon: Rp " . number_format($produk['harga_diskon'], 0, ',', '.') . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>Tidak ada produk dalam promo ini</p>";
        }
        
        echo "<hr>";
    }
} else {
    echo "<p>Tidak ada data promo</p>";
}

$conn->close();
?>

