<!DOCTYPE html>
<html>
<head>
    <title>Fix Promo Langsung</title>
    <meta http-equiv="refresh" content="3;url=admin/promo">
    <style>
        body { 
            font-family: Arial; 
            padding: 50px; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-align: center;
        }
        .container { 
            max-width: 600px; 
            margin: 0 auto; 
            background: white; 
            color: #333;
            padding: 40px; 
            border-radius: 15px; 
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }
        .success { 
            background: #28a745; 
            color: white; 
            padding: 20px; 
            border-radius: 10px; 
            margin: 20px 0;
            font-size: 18px;
        }
        .loading { 
            display: inline-block;
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        h1 { color: #667eea; margin-bottom: 30px; }
        .btn { 
            display: inline-block;
            background: #667eea; 
            color: white; 
            padding: 15px 30px; 
            border-radius: 8px; 
            text-decoration: none; 
            margin: 10px;
            font-weight: bold;
        }
        .details { 
            background: #f8f9fa; 
            padding: 20px; 
            border-radius: 8px; 
            margin: 20px 0;
            text-align: left;
        }
        .details ul { line-height: 2; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 Auto Fix Promo</h1>
        
        <?php
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            echo "<div style='background: #dc3545; color: white; padding: 20px; border-radius: 8px;'>";
            echo "❌ Koneksi database gagal";
            echo "</div>";
            exit;
        }
        
        // Waktu sekarang dan 2 jam yang lalu (biar pasti sudah lewat)
        $now = date('Y-m-d H:i:s');
        $dua_jam_lalu = date('Y-m-d H:i:s', strtotime('-2 hours'));
        $besok = date('Y-m-d H:i:s', strtotime('+1 day'));
        
        echo "<div class='loading'></div>";
        echo "<p>Sedang memperbaiki waktu promo...</p>";
        
        // UPDATE LANGSUNG
        $sql = "UPDATE promo SET 
            status_promo = 'aktif',
            waktu_mulai = '$dua_jam_lalu',
            waktu_berakhir = '$besok'
            WHERE 1=1";
        
        if($conn->query($sql)) {
            $affected = $conn->affected_rows;
            
            echo "<div class='success'>";
            echo "<h2>✅ Berhasil!</h2>";
            echo "<p><strong>{$affected} Promo telah diupdate</strong></p>";
            echo "</div>";
            
            echo "<div class='details'>";
            echo "<strong>📝 Perubahan:</strong>";
            echo "<ul>";
            echo "<li>✓ Status: <strong>aktif</strong></li>";
            echo "<li>✓ Waktu Mulai: <strong>{$dua_jam_lalu}</strong></li>";
            echo "<li>✓ Waktu Berakhir: <strong>{$besok}</strong></li>";
            echo "<li>✓ Waktu Sekarang: <strong>{$now}</strong></li>";
            echo "</ul>";
            echo "<p style='color: #28a745; font-weight: bold;'>✓ Promo sudah AKTIF dan akan tampil di customer!</p>";
            echo "</div>";
            
            echo "<p style='color: #666; margin-top: 30px;'>Anda akan diarahkan ke halaman admin dalam 3 detik...</p>";
            echo "<p>";
            echo "<a href='admin/promo' class='btn'>🔙 Ke Admin Promo</a>";
            echo "<a href='customer' class='btn' style='background: #28a745;'>🏠 Lihat Customer</a>";
            echo "</p>";
            
        } else {
            echo "<div style='background: #dc3545; color: white; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
            echo "<h3>❌ Gagal Update</h3>";
            echo "<p>" . $conn->error . "</p>";
            echo "</div>";
        }
        
        $conn->close();
        ?>
    </div>
</body>
</html>

