<!DOCTYPE html>
<html>
<head>
    <title>Fix Status Promo</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .btn { background: #1a1f3a; color: white; padding: 12px 24px; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; margin: 10px 5px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Fix Status & Waktu Promo</h1>
        
        <?php
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            echo "<div class='error'>❌ Koneksi database gagal</div>";
            exit;
        }
        
        if(isset($_POST['fix'])) {
            $now = date('Y-m-d H:i:s');
            $besok = date('Y-m-d H:i:s', strtotime('+1 day'));
            
            // Update semua promo: set status = 'aktif' dan waktu mulai = sekarang, berakhir = besok
            $sql = "UPDATE promo SET 
                status_promo = 'aktif',
                waktu_mulai = '$now',
                waktu_berakhir = '$besok'
                WHERE 1=1";
            
            if($conn->query($sql)) {
                $affected = $conn->affected_rows;
                echo "<div class='success'>✅ {$affected} promo berhasil diupdate!</div>";
                echo "<div class='success'>";
                echo "<p><strong>Perubahan:</strong></p>";
                echo "<ul>";
                echo "<li>Status: <strong>aktif</strong></li>";
                echo "<li>Waktu Mulai: <strong>{$now}</strong></li>";
                echo "<li>Waktu Berakhir: <strong>{$besok}</strong> (24 jam dari sekarang)</li>";
                echo "</ul>";
                echo "</div>";
                
                echo "<p><a href='customer/test_simple_query.php' class='btn'>🔍 Cek Hasil</a></p>";
                echo "<p><a href='customer' class='btn'>🏠 Ke Halaman Customer</a></p>";
            } else {
                echo "<div class='error'>❌ Gagal update: " . $conn->error . "</div>";
            }
        } else {
            // Tampilkan status promo saat ini
            $sql = "SELECT * FROM promo";
            $result = $conn->query($sql);
            
            if($result && $result->num_rows > 0) {
                echo "<h2>Status Promo Saat Ini:</h2>";
                echo "<table border='1' cellpadding='10' style='width:100%; border-collapse: collapse;'>";
                echo "<tr style='background:#1a1f3a; color:white;'><th>Nama Promo</th><th>Status</th><th>Waktu Mulai</th><th>Waktu Berakhir</th></tr>";
                
                while($promo = $result->fetch_assoc()) {
                    $bg = $promo['status_promo'] == 'aktif' ? '#d4edda' : '#f8d7da';
                    echo "<tr style='background:{$bg};'>";
                    echo "<td><strong>{$promo['nama_promo']}</strong></td>";
                    echo "<td>{$promo['status_promo']}</td>";
                    echo "<td>{$promo['waktu_mulai']}</td>";
                    echo "<td>{$promo['waktu_berakhir']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
            
            echo "<hr>";
            echo "<p><strong>Script ini akan:</strong></p>";
            echo "<ul>";
            echo "<li>✅ Set status semua promo menjadi <strong>'aktif'</strong></li>";
            echo "<li>✅ Set waktu mulai menjadi <strong>SEKARANG</strong></li>";
            echo "<li>✅ Set waktu berakhir menjadi <strong>24 JAM dari sekarang</strong></li>";
            echo "</ul>";
            
            echo "<form method='POST'>";
            echo "<button type='submit' name='fix' class='btn'>🔧 FIX PROMO SEKARANG</button>";
            echo "</form>";
        }
        
        $conn->close();
        ?>
    </div>
</body>
</html>

