<!DOCTYPE html>
<html>
<head>
    <title>Fix Waktu Promo</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #dc3545; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #17a2b8; }
        .warning { background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #ffc107; }
        .btn { background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%); color: white; padding: 14px 28px; border: none; border-radius: 8px; cursor: pointer; text-decoration: none; display: inline-block; margin: 10px 5px; font-size: 16px; font-weight: 600; transition: transform 0.2s; }
        .btn:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(26, 31, 58, 0.4); }
        .btn-success { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border: 1px solid #dee2e6; }
        th { background: #1a1f3a; color: white; font-weight: 600; }
        tr:nth-child(even) { background: #f8f9fa; }
        h1 { color: #1a1f3a; margin-bottom: 10px; }
        h2 { color: #2c3e5e; margin-top: 30px; border-bottom: 2px solid #d4af37; padding-bottom: 10px; }
        .time-info { background: #fff; border: 2px solid #d4af37; padding: 15px; border-radius: 8px; margin: 20px 0; }
        .time-info strong { color: #1a1f3a; font-size: 18px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🕐 Fix Waktu Promo - Set ke AKTIF Sekarang</h1>
        
        <?php
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            echo "<div class='error'>❌ Koneksi database gagal: " . $conn->connect_error . "</div>";
            exit;
        }
        
        // Waktu sekarang
        $now = date('Y-m-d H:i:s');
        $satu_jam_lalu = date('Y-m-d H:i:s', strtotime('-1 hour'));
        $besok = date('Y-m-d H:i:s', strtotime('+1 day'));
        
        echo "<div class='time-info'>";
        echo "<strong>⏰ Waktu Server Saat Ini:</strong> <span style='color: #28a745; font-size: 20px;'>{$now}</span>";
        echo "</div>";
        
        if(isset($_POST['fix'])) {
            echo "<h2>📝 Proses Update...</h2>";
            
            // Update semua promo: set waktu mulai = 1 jam yang lalu, berakhir = besok
            $sql = "UPDATE promo SET 
                status_promo = 'aktif',
                waktu_mulai = '$satu_jam_lalu',
                waktu_berakhir = '$besok'";
            
            if($conn->query($sql)) {
                $affected = $conn->affected_rows;
                
                echo "<div class='success'>";
                echo "<h3>✅ Berhasil Update {$affected} Promo!</h3>";
                echo "<p><strong>Perubahan yang dilakukan:</strong></p>";
                echo "<ul style='line-height: 1.8;'>";
                echo "<li>✓ Status: <strong style='color: #28a745;'>aktif</strong></li>";
                echo "<li>✓ Waktu Mulai: <strong style='color: #28a745;'>{$satu_jam_lalu}</strong> (1 jam yang lalu)</li>";
                echo "<li>✓ Waktu Berakhir: <strong style='color: #28a745;'>{$besok}</strong> (24 jam dari sekarang)</li>";
                echo "</ul>";
                echo "</div>";
                
                echo "<div class='info'>";
                echo "<p><strong>🎯 Status Promo Sekarang:</strong> <span style='color: #28a745; font-size: 18px; font-weight: bold;'>AKTIF & BERJALAN</span></p>";
                echo "<p>Promo akan tampil di halaman customer dengan badge diskon merah!</p>";
                echo "</div>";
                
                echo "<p style='margin-top: 30px;'>";
                echo "<a href='customer' class='btn btn-success'>🏠 Lihat Halaman Customer</a>";
                echo "<a href='customer/test_simple_query.php' class='btn'>🔍 Cek Status Detail</a>";
                echo "<a href='admin/promo' class='btn'>⚙️ Ke Admin Promo</a>";
                echo "</p>";
                
            } else {
                echo "<div class='error'>❌ Gagal update: " . $conn->error . "</div>";
            }
            
        } else {
            // Tampilkan status promo saat ini
            echo "<h2>📋 Status Promo Saat Ini</h2>";
            
            $sql = "SELECT * FROM promo ORDER BY id_promo DESC";
            $result = $conn->query($sql);
            
            if($result && $result->num_rows > 0) {
                echo "<table>";
                echo "<tr>
                    <th>No</th>
                    <th>Nama Promo</th>
                    <th>Status DB</th>
                    <th>Waktu Mulai</th>
                    <th>Waktu Berakhir</th>
                    <th>Status Aktual</th>
                </tr>";
                
                $no = 1;
                while($promo = $result->fetch_assoc()) {
                    $waktu_mulai = strtotime($promo['waktu_mulai']);
                    $waktu_berakhir = strtotime($promo['waktu_berakhir']);
                    $waktu_sekarang = strtotime($now);
                    
                    $status_aktual = "";
                    $color = "";
                    
                    if($promo['status_promo'] != 'aktif') {
                        $status_aktual = "Nonaktif";
                        $color = "#dc3545";
                    } elseif($waktu_mulai > $waktu_sekarang) {
                        $status_aktual = "Belum Dimulai";
                        $color = "#ffc107";
                    } elseif($waktu_berakhir < $waktu_sekarang) {
                        $status_aktual = "Sudah Berakhir";
                        $color = "#6c757d";
                    } else {
                        $status_aktual = "✓ AKTIF";
                        $color = "#28a745";
                    }
                    
                    echo "<tr>";
                    echo "<td>{$no}</td>";
                    echo "<td><strong>{$promo['nama_promo']}</strong></td>";
                    echo "<td>{$promo['status_promo']}</td>";
                    echo "<td>{$promo['waktu_mulai']}</td>";
                    echo "<td>{$promo['waktu_berakhir']}</td>";
                    echo "<td><strong style='color: {$color};'>{$status_aktual}</strong></td>";
                    echo "</tr>";
                    
                    $no++;
                }
                echo "</table>";
                
                echo "<div class='warning'>";
                echo "<p><strong>⚠️ Masalah Terdeteksi:</strong></p>";
                echo "<p>Waktu mulai promo masih di masa depan, sehingga status menunjukkan <strong>'Belum Dimulai'</strong></p>";
                echo "<p>Promo tidak akan tampil di customer sampai waktu mulai tercapai.</p>";
                echo "</div>";
                
            } else {
                echo "<div class='error'>❌ Tidak ada promo di database</div>";
            }
            
            echo "<hr style='margin: 40px 0; border: none; border-top: 2px solid #e9ecef;'>";
            
            echo "<div class='info'>";
            echo "<h3>💡 Solusi</h3>";
            echo "<p>Script ini akan mengupdate SEMUA promo dengan:</p>";
            echo "<ul style='line-height: 1.8;'>";
            echo "<li>✓ Status: <strong>aktif</strong></li>";
            echo "<li>✓ Waktu Mulai: <strong>{$satu_jam_lalu}</strong> (1 jam yang lalu - sudah lewat)</li>";
            echo "<li>✓ Waktu Berakhir: <strong>{$besok}</strong> (24 jam dari sekarang)</li>";
            echo "</ul>";
            echo "<p style='color: #28a745; font-weight: bold;'>Dengan ini, promo akan langsung AKTIF dan tampil di customer!</p>";
            echo "</div>";
            
            echo "<form method='POST' style='text-align: center; margin-top: 30px;'>";
            echo "<button type='submit' name='fix' class='btn btn-success' style='font-size: 18px; padding: 16px 40px;'>🚀 FIX WAKTU PROMO SEKARANG</button>";
            echo "</form>";
        }
        
        $conn->close();
        ?>
    </div>
</body>
</html>

