<!DOCTYPE html>
<html>
<head>
    <title>Run SQL Fix</title>
    <style>
        body { font-family: monospace; background: #1e1e1e; color: #d4d4d4; padding: 20px; }
        .container { max-width: 1000px; margin: 0 auto; }
        .success { background: #4caf50; color: white; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .error { background: #f44336; color: white; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .sql { background: #2d2d2d; padding: 15px; border-radius: 5px; margin: 10px 0; border-left: 3px solid #4caf50; }
        .info { background: #2196f3; color: white; padding: 15px; border-radius: 5px; margin: 10px 0; }
        pre { margin: 0; white-space: pre-wrap; }
        h1 { color: #4caf50; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; background: #2d2d2d; }
        th, td { padding: 12px; border: 1px solid #444; text-align: left; }
        th { background: #4caf50; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <h1>⚡ SQL Fix - Update Promo Langsung</h1>
        
        <?php
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            echo "<div class='error'>❌ Connection failed: " . $conn->connect_error . "</div>";
            exit;
        }
        
        echo "<div class='info'>✓ Connected to database: gerabah</div>";
        
        // Tampilkan waktu server
        $now = date('Y-m-d H:i:s');
        $satu_jam_lalu = date('Y-m-d H:i:s', strtotime('-1 hour'));
        $besok = date('Y-m-d H:i:s', strtotime('+1 day'));
        
        echo "<div class='sql'>";
        echo "<strong>Waktu Server:</strong><br>";
        echo "NOW: <span style='color: #4caf50;'>{$now}</span><br>";
        echo "1 JAM LALU: <span style='color: #4caf50;'>{$satu_jam_lalu}</span><br>";
        echo "BESOK: <span style='color: #4caf50;'>{$besok}</span>";
        echo "</div>";
        
        // Tampilkan data SEBELUM update
        echo "<h2>📋 Data Promo SEBELUM Update:</h2>";
        $result_before = $conn->query("SELECT * FROM promo");
        if($result_before && $result_before->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>ID</th><th>Nama</th><th>Status</th><th>Waktu Mulai</th><th>Waktu Berakhir</th></tr>";
            while($row = $result_before->fetch_assoc()) {
                echo "<tr>";
                echo "<td>{$row['id_promo']}</td>";
                echo "<td>{$row['nama_promo']}</td>";
                echo "<td style='color: " . ($row['status_promo'] == 'aktif' ? '#4caf50' : '#f44336') . ";'><strong>{$row['status_promo']}</strong></td>";
                echo "<td>{$row['waktu_mulai']}</td>";
                echo "<td>{$row['waktu_berakhir']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
        // JALANKAN UPDATE
        echo "<h2>🚀 Menjalankan UPDATE...</h2>";
        
        $sql_update = "UPDATE promo SET 
            status_promo = 'aktif',
            waktu_mulai = '$satu_jam_lalu',
            waktu_berakhir = '$besok'";
        
        echo "<div class='sql'>";
        echo "<strong>SQL Query:</strong><br>";
        echo "<pre>" . htmlspecialchars($sql_update) . "</pre>";
        echo "</div>";
        
        if($conn->query($sql_update)) {
            $affected = $conn->affected_rows;
            echo "<div class='success'>";
            echo "✅ <strong>UPDATE BERHASIL!</strong><br>";
            echo "Rows affected: <strong>{$affected}</strong>";
            echo "</div>";
        } else {
            echo "<div class='error'>";
            echo "❌ <strong>UPDATE GAGAL!</strong><br>";
            echo "Error: " . $conn->error;
            echo "</div>";
        }
        
        // Tampilkan data SETELAH update
        echo "<h2>📋 Data Promo SETELAH Update:</h2>";
        $result_after = $conn->query("SELECT * FROM promo");
        if($result_after && $result_after->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>ID</th><th>Nama</th><th>Status</th><th>Waktu Mulai</th><th>Waktu Berakhir</th><th>Valid?</th></tr>";
            while($row = $result_after->fetch_assoc()) {
                $waktu_mulai = strtotime($row['waktu_mulai']);
                $waktu_sekarang = strtotime($now);
                $waktu_berakhir = strtotime($row['waktu_berakhir']);
                
                $is_valid = ($row['status_promo'] == 'aktif' && $waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang);
                
                echo "<tr>";
                echo "<td>{$row['id_promo']}</td>";
                echo "<td>{$row['nama_promo']}</td>";
                echo "<td style='color: " . ($row['status_promo'] == 'aktif' ? '#4caf50' : '#f44336') . ";'><strong>{$row['status_promo']}</strong></td>";
                echo "<td>{$row['waktu_mulai']}</td>";
                echo "<td>{$row['waktu_berakhir']}</td>";
                echo "<td style='color: " . ($is_valid ? '#4caf50' : '#f44336') . "; font-weight: bold;'>" . ($is_valid ? '✓ AKTIF' : '✗ TIDAK') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
        echo "<div class='success'>";
        echo "<h2>✅ Selesai!</h2>";
        echo "<p>Promo sudah diupdate. Silakan:</p>";
        echo "<ol>";
        echo "<li>Refresh halaman <strong>Admin Promo</strong></li>";
        echo "<li>Refresh halaman <strong>Customer</strong></li>";
        echo "<li>Badge diskon merah akan muncul di produk yang ada promo</li>";
        echo "</ol>";
        echo "</div>";
        
        echo "<p style='margin-top: 30px;'>";
        echo "<a href='admin/promo' style='background: #4caf50; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; display: inline-block; margin-right: 10px;'>🔙 Ke Admin Promo</a>";
        echo "<a href='customer' style='background: #2196f3; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; display: inline-block;'>🏠 Lihat Customer</a>";
        echo "</p>";
        
        $conn->close();
        ?>
    </div>
</body>
</html>

