<?php
// Load CodeIgniter
define('BASEPATH', 'system/');
define('ENVIRONMENT', 'development');

// Context
$system_path = 'system';
$application_folder = 'admin/application';

if (realpath($system_path) !== FALSE) {
	$system_path = realpath($system_path) . '/';
}

// Path to the system folder
define('SYSDIR', str_replace("\\", "/", $system_path));

// Path to the front controller (this file)
define('FCPATH', str_replace(SELF, '', __FILE__));

// Name of the "system" folder
define('SYSDIR_NAME', trim(strrchr(trim(SYSDIR, '/'), '/'), '/'));

// The path to the "application" folder
if (is_dir($application_folder)) {
	if (($_temp = realpath($application_folder)) !== FALSE) {
		$application_folder = $_temp;
	}

	define('APPPATH', $application_folder . DIRECTORY_SEPARATOR);
} else {
	if (!is_dir(SYSDIR . $application_folder . DIRECTORY_SEPARATOR)) {
		header('HTTP/1.1 503 Service Unavailable.', TRUE, 503);
		echo 'Your application folder path does not appear to be set correctly. Please open the following file and correct this: ' . SELF;
		exit(3); // EXIT_CONFIG
	}

	define('APPPATH', SYSDIR . $application_folder . DIRECTORY_SEPARATOR);
}

// Basic CI setup to get DB
require_once(BASEPATH . 'core/Common.php');
require_once(BASEPATH . 'core/Controller.php');
require_once(BASEPATH . 'core/Model.php');
require_once(BASEPATH . 'core/Config.php');
require_once(BASEPATH . 'core/Input.php');
require_once(BASEPATH . 'core/Lang.php');
require_once(BASEPATH . 'database/DB.php');

$db =& DB();

// 1. Create produk_ukuran table
$sql = "CREATE TABLE IF NOT EXISTS produk_ukuran (
    id_ukuran INT(11) NOT NULL AUTO_INCREMENT,
    id_produk INT(11) NOT NULL,
    ukuran VARCHAR(50) NOT NULL,
    harga INT(11) NOT NULL,
    PRIMARY KEY (id_ukuran),
    INDEX (id_produk)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

if ($db->query($sql)) {
    echo "Table produk_ukuran created successfully.<br>";
} else {
    echo "Error creating table produk_ukuran: " . $db->error()['message'] . "<br>";
}

// 2. Add id_ukuran to keranjang table if not exists
if (!$db->field_exists('id_ukuran', 'keranjang')) {
    $sql = "ALTER TABLE keranjang ADD COLUMN id_ukuran INT(11) NULL DEFAULT NULL AFTER id_produk";
    if ($db->query($sql)) {
        echo "Column id_ukuran added to keranjang.<br>";
    } else {
        echo "Error adding column to keranjang: " . $db->error()['message'] . "<br>";
    }
} else {
    echo "Column id_ukuran already exists in keranjang.<br>";
}

// 3. Add ukuran to transaksi_detail table if not exists
if ($db->table_exists('transaksi_detail')) {
    if (!$db->field_exists('ukuran', 'transaksi_detail')) {
        $sql = "ALTER TABLE transaksi_detail ADD COLUMN ukuran VARCHAR(50) NULL DEFAULT NULL AFTER qty";
        if ($db->query($sql)) {
            echo "Column ukuran added to transaksi_detail.<br>";
        } else {
            echo "Error adding column to transaksi_detail: " . $db->error()['message'] . "<br>";
        }
    } else {
        echo "Column ukuran already exists in transaksi_detail.<br>";
    }
} else {
    echo "Table transaksi_detail does not exist.<br>";
}

echo "Database setup completed.";
?>