<?php
// Database configuration
$host = "localhost";
$username = "root";
$password = "";
$database = "gerabah";

// Create connection
$conn = new mysqli($host, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "Connected successfully to database.\n";

// 1. Create table notifikasi if not exists
$sql_create = "CREATE TABLE IF NOT EXISTS `notifikasi` (
  `id_notifikasi` int(11) NOT NULL AUTO_INCREMENT,
  `judul` varchar(255) NOT NULL,
  `pesan` text NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `jenis` enum('transaksi','stok','info') NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_notifikasi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

if ($conn->query($sql_create) === TRUE) {
    echo "Table 'notifikasi' checked/created successfully.\n";
} else {
    echo "Error creating table: " . $conn->error . "\n";
}

// 2. Check for low stock products (<= 10)
$threshold = 10;
$sql_produk = "SELECT id_produk, nama_produk, stok_produk FROM produk WHERE stok_produk <= $threshold";
$result_produk = $conn->query($sql_produk);

if ($result_produk->num_rows > 0) {
    echo "Found " . $result_produk->num_rows . " products with low stock.\n";
    while($row = $result_produk->fetch_assoc()) {
        $id = $row['id_produk'];
        $nama = $conn->real_escape_string($row['nama_produk']);
        $stok = $row['stok_produk'];
        $link = "produk/edit/" . $id;
        
        // Check if notification exists
        $sql_check = "SELECT id_notifikasi FROM notifikasi WHERE link = '$link' AND jenis = 'stok' AND is_read = 0";
        $result_check = $conn->query($sql_check);
        
        if ($result_check->num_rows == 0) {
            $pesan = "Stok produk <b>$nama</b> tersisa $stok.";
            $sql_insert = "INSERT INTO notifikasi (judul, pesan, link, jenis, is_read) VALUES ('Stok Barang Rendah', '$pesan', '$link', 'stok', 0)";
            if ($conn->query($sql_insert) === TRUE) {
                echo "Inserted notification for product: $nama\n";
            } else {
                echo "Error inserting notification: " . $conn->error . "\n";
            }
        } else {
            echo "Notification already exists for product: $nama\n";
        }
    }
} else {
    echo "No products found with stock <= $threshold.\n";
}

// 3. Check for recent pending transactions (last 24 hours) to ensure we didn't miss any
$sql_transaksi = "SELECT t.id_transaksi, t.kode_transaksi, c.nama_customer 
                  FROM transaksi t 
                  LEFT JOIN customer c ON t.id_customer = c.id_customer 
                  WHERE t.created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)
                  ORDER BY t.created_at DESC";
$result_transaksi = $conn->query($sql_transaksi);

if ($result_transaksi->num_rows > 0) {
    echo "Checking " . $result_transaksi->num_rows . " recent transactions.\n";
    while($row = $result_transaksi->fetch_assoc()) {
        $id_trans = $row['id_transaksi'];
        $kode = $row['kode_transaksi'];
        $nama_cust = $row['nama_customer'] ? $row['nama_customer'] : 'Customer';
        $link = "transaksi/detail/" . $id_trans;
        
        // Check if notification exists
        $sql_check = "SELECT id_notifikasi FROM notifikasi WHERE link = '$link' AND jenis = 'transaksi'";
        $result_check = $conn->query($sql_check);
        
        if ($result_check->num_rows == 0) {
            $pesan = "Pesanan baru $kode dari $nama_cust";
            $sql_insert = "INSERT INTO notifikasi (judul, pesan, link, jenis, is_read) VALUES ('Transaksi Baru', '$pesan', '$link', 'transaksi', 0)";
            if ($conn->query($sql_insert) === TRUE) {
                echo "Inserted notification for transaction: $kode\n";
            } else {
                echo "Error inserting notification: " . $conn->error . "\n";
            }
        }
    }
}

$conn->close();
?>