<!DOCTYPE html>
<html>
<head>
    <title>Setup Promo Otomatis</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .btn { background: #1a1f3a; color: white; padding: 12px 24px; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; margin: 10px 5px; }
        .btn:hover { background: #2c3e5e; }
        h1 { color: #1a1f3a; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 Setup Promo Otomatis</h1>
        <p>Script ini akan menambahkan semua produk ke promo "akhir tahun" dengan diskon 20%</p>
        
        <?php
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            echo "<div class='error'>❌ Koneksi database gagal: " . $conn->connect_error . "</div>";
            exit;
        }
        
        if(isset($_POST['setup'])) {
            echo "<h2>Proses Setup:</h2>";
            
            // 1. Cari promo "akhir tahun"
            $sql_promo = "SELECT * FROM promo WHERE nama_promo LIKE '%akhir tahun%' ORDER BY id_promo DESC LIMIT 1";
            $result_promo = $conn->query($sql_promo);
            
            if($result_promo && $result_promo->num_rows > 0) {
                $promo = $result_promo->fetch_assoc();
                $id_promo = $promo['id_promo'];
                $tipe_diskon = $promo['tipe_diskon'];
                $nilai_diskon = $promo['nilai_diskon'];
                
                echo "<div class='success'>✅ Promo ditemukan: {$promo['nama_promo']} ({$nilai_diskon}" . ($tipe_diskon == 'persen' ? '%' : '') . ")</div>";
                
                // 2. Ambil semua produk
                $sql_produk = "SELECT * FROM produk ORDER BY id_produk DESC LIMIT 10";
                $result_produk = $conn->query($sql_produk);
                
                if($result_produk && $result_produk->num_rows > 0) {
                    $added = 0;
                    $skipped = 0;
                    
                    while($produk = $result_produk->fetch_assoc()) {
                        $id_produk = $produk['id_produk'];
                        $harga_awal = $produk['harga_produk'];
                        
                        // Hitung harga diskon
                        if($tipe_diskon == 'persen') {
                            $harga_diskon = $harga_awal - ($harga_awal * $nilai_diskon / 100);
                        } else {
                            $harga_diskon = $harga_awal - $nilai_diskon;
                        }
                        
                        // Cek apakah sudah ada
                        $sql_cek = "SELECT * FROM promo_produk WHERE id_promo = $id_promo AND id_produk = $id_produk";
                        $result_cek = $conn->query($sql_cek);
                        
                        if($result_cek->num_rows > 0) {
                            echo "<div class='info'>⏭️ {$produk['nama_produk']} - Sudah ada, diupdate</div>";
                            $sql_update = "UPDATE promo_produk SET harga_awal = $harga_awal, harga_diskon = $harga_diskon WHERE id_promo = $id_promo AND id_produk = $id_produk";
                            $conn->query($sql_update);
                            $skipped++;
                        } else {
                            // Insert
                            $sql_insert = "INSERT INTO promo_produk (id_promo, id_produk, harga_awal, harga_diskon) VALUES ($id_promo, $id_produk, $harga_awal, $harga_diskon)";
                            if($conn->query($sql_insert)) {
                                echo "<div class='success'>✅ {$produk['nama_produk']} - Ditambahkan! (Rp " . number_format($harga_awal, 0) . " → Rp " . number_format($harga_diskon, 0) . ")</div>";
                                $added++;
                            } else {
                                echo "<div class='error'>❌ {$produk['nama_produk']} - Gagal: " . $conn->error . "</div>";
                            }
                        }
                    }
                    
                    echo "<h3>📊 Ringkasan:</h3>";
                    echo "<p><strong>Produk ditambahkan:</strong> {$added}</p>";
                    echo "<p><strong>Produk diupdate:</strong> {$skipped}</p>";
                    echo "<div class='success'>✅ <strong>Setup selesai!</strong> Silakan refresh halaman customer untuk melihat promo.</div>";
                    
                    echo "<a href='http://localhost/gerabah/customer' class='btn'>🏠 Ke Halaman Customer</a>";
                    echo "<a href='customer/cek_promo.php' class='btn'>🔍 Lihat Status Promo</a>";
                    
                } else {
                    echo "<div class='error'>❌ Tidak ada produk di database</div>";
                }
                
            } else {
                echo "<div class='error'>❌ Promo 'akhir tahun' tidak ditemukan!</div>";
                echo "<div class='info'>💡 Silakan buat promo terlebih dahulu di halaman admin</div>";
            }
            
        } else {
            // Tampilkan form
            ?>
            <div class='info'>
                <strong>ℹ️ Informasi:</strong>
                <ul>
                    <li>Script ini akan menambahkan semua produk ke promo yang ada</li>
                    <li>Harga diskon akan dihitung otomatis</li>
                    <li>Produk yang sudah ada akan diupdate</li>
                </ul>
            </div>
            
            <form method="POST">
                <button type="submit" name="setup" class="btn">▶️ Jalankan Setup Promo</button>
            </form>
            
            <hr>
            <p><a href="customer/cek_promo.php" class="btn">🔍 Cek Status Promo</a></p>
            <?php
        }
        
        $conn->close();
        ?>
    </div>
</body>
</html>

