<?php
// Script to synchronize refund totals in transaction table
$mysqli = new mysqli("localhost", "root", "", "gerabah");

if ($mysqli->connect_errno) {
    echo "Failed to connect to MySQL: " . $mysqli->connect_error;
    exit();
}

echo "Starting Refund Synchronization...\n";

// Get all transactions that have completed refunds
$sql = "SELECT id_transaksi, SUM(nominal_refund) as total_refund 
        FROM retur 
        WHERE status_retur = 'selesai' AND jenis_retur = 'refund_dana'
        GROUP BY id_transaksi";

$result = $mysqli->query($sql);

if ($result) {
    echo "Found " . $result->num_rows . " transactions with completed refunds.\n";
    
    $updated_count = 0;
    while ($row = $result->fetch_assoc()) {
        $id_transaksi = $row['id_transaksi'];
        $total_refund = $row['total_refund'];
        
        echo "Updating Transaction #$id_transaksi with Total Refund: Rp " . number_format($total_refund, 0, ',', '.') . "... ";
        
        $update_sql = "UPDATE transaksi SET total_refund = $total_refund WHERE id_transaksi = $id_transaksi";
        if ($mysqli->query($update_sql)) {
            echo "Success.\n";
            $updated_count++;
        } else {
            echo "Failed: " . $mysqli->error . "\n";
        }
    }
    
    echo "\nSynchronization Completed. Updated $updated_count transactions.\n";
} else {
    echo "Error querying returns: " . $mysqli->error . "\n";
}

// Also, set total_refund to 0 for transactions that have no completed refunds (to be clean)
// This is optional but good for consistency if we want to rely on 0 instead of NULL
$mysqli->query("UPDATE transaksi SET total_refund = 0 WHERE total_refund IS NULL");

echo "Done.\n";
?>