<?php
// Simulate CodeIgniter environment
define('BASEPATH', 'system/');
define('APPPATH', 'application/');
define('ENVIRONMENT', 'development');

// Set timezone (The Fix)
date_default_timezone_set('Asia/Jakarta');

// Mock data from Database
$produk = (object) [
    'id_produk' => 3,
    'nama_produk' => 'vas bunga',
    'harga_produk' => 15000,
    // Joined columns from Promo
    'harga_diskon' => 7500,
    'status_promo' => 'aktif',
    'waktu_mulai' => '2026-02-02 23:19:00',
    'waktu_berakhir' => '2026-02-03 00:19:00'
];

echo "Current Time: " . date('Y-m-d H:i:s') . "\n";
echo "Promo Start: " . $produk->waktu_mulai . "\n";
echo "Promo End: " . $produk->waktu_berakhir . "\n";

// Logic from promo_helper.php
$now = date('Y-m-d H:i:s');
$promo_aktif = false;

if(isset($produk->status_promo) && $produk->status_promo == 'aktif') {
    if(isset($produk->waktu_mulai) && isset($produk->waktu_berakhir)) {
        $waktu_mulai = strtotime($produk->waktu_mulai);
        $waktu_berakhir = strtotime($produk->waktu_berakhir);
        $waktu_sekarang = strtotime($now);
        
        if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
            $promo_aktif = true;
        } else {
            echo "Promo Inactive due to time.\n";
            echo "Start <= Now? " . ($waktu_mulai <= $waktu_sekarang ? 'Yes' : 'No') . "\n";
            echo "End >= Now? " . ($waktu_berakhir >= $waktu_sekarang ? 'Yes' : 'No') . "\n";
        }
    }
}

if($promo_aktif) {
    echo "RESULT: Promo is ACTIVE. Discount applied.\n";
} else {
    echo "RESULT: Promo is INACTIVE.\n";
}
?>