<?php
// Test query promo
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "gerabah";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$now = date('Y-m-d H:i:s');
echo "<h2>Test Query Promo</h2>";
echo "<p><strong>Waktu Sekarang:</strong> $now</p><hr>";

// Query sama seperti di model
$sql = "SELECT produk.*, kategori.nama_kategori, 
    CASE 
        WHEN promo.status_promo = 'aktif' 
            AND promo.waktu_mulai <= '$now' 
            AND promo.waktu_berakhir >= '$now' 
        THEN promo_produk.harga_diskon 
        ELSE NULL 
    END as harga_diskon,
    CASE 
        WHEN promo.status_promo = 'aktif' 
            AND promo.waktu_mulai <= '$now' 
            AND promo.waktu_berakhir >= '$now' 
        THEN promo.tipe_diskon 
        ELSE NULL 
    END as tipe_diskon,
    CASE 
        WHEN promo.status_promo = 'aktif' 
            AND promo.waktu_mulai <= '$now' 
            AND promo.waktu_berakhir >= '$now' 
        THEN promo.nilai_diskon 
        ELSE NULL 
    END as nilai_diskon,
    promo.nama_promo, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir
FROM produk
LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
ORDER BY produk.id_produk DESC
LIMIT 10";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #1a1f3a; color: white;'>
            <th>ID</th>
            <th>Nama Produk</th>
            <th>Harga Normal</th>
            <th>Harga Diskon</th>
            <th>Tipe Diskon</th>
            <th>Nilai Diskon</th>
            <th>Nama Promo</th>
            <th>Status Promo</th>
            <th>Waktu Mulai</th>
            <th>Waktu Berakhir</th>
          </tr>";
    
    while($row = $result->fetch_assoc()) {
        $has_promo = !is_null($row['harga_diskon']) && $row['harga_diskon'] > 0;
        $bg_color = $has_promo ? '#d4edda' : '#ffffff';
        
        echo "<tr style='background: $bg_color;'>";
        echo "<td>" . $row['id_produk'] . "</td>";
        echo "<td>" . $row['nama_produk'] . "</td>";
        echo "<td>Rp " . number_format($row['harga_produk'], 0, ',', '.') . "</td>";
        echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0, ',', '.') : '<span style="color: red;">NULL</span>') . "</td>";
        echo "<td>" . ($row['tipe_diskon'] ? $row['tipe_diskon'] : '-') . "</td>";
        echo "<td>" . ($row['nilai_diskon'] ? $row['nilai_diskon'] : '-') . "</td>";
        echo "<td>" . ($row['nama_promo'] ? $row['nama_promo'] : '-') . "</td>";
        echo "<td>" . ($row['status_promo'] ? $row['status_promo'] : '-') . "</td>";
        echo "<td>" . ($row['waktu_mulai'] ? $row['waktu_mulai'] : '-') . "</td>";
        echo "<td>" . ($row['waktu_berakhir'] ? $row['waktu_berakhir'] : '-') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Tidak ada produk</p>";
}

$conn->close();

echo "<hr>";
echo "<p><strong>Keterangan:</strong></p>";
echo "<ul>";
echo "<li>Baris hijau = produk dengan promo aktif</li>";
echo "<li>Baris putih = produk tanpa promo atau promo tidak aktif</li>";
echo "</ul>";
?>

