-- Update tabel produk
ALTER TABLE `produk` ADD COLUMN `status_produk` ENUM('aktif', 'nonaktif') DEFAULT 'aktif';

-- Update tabel transaksi jika belum ada kolom yang dibutuhkan
ALTER TABLE `transaksi` ADD COLUMN `no_transaksi` VARCHAR(50) DEFAULT NULL;
ALTER TABLE `transaksi` ADD COLUMN `status_transaksi` VARCHAR(50) DEFAULT 'pending';
ALTER TABLE `transaksi` ADD COLUMN `nama_customer` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `transaksi` ADD COLUMN `total_harga` DECIMAL(15,2) DEFAULT 0;
ALTER TABLE `transaksi` CHANGE COLUMN `status` `status` VARCHAR(50) DEFAULT 'pending';

-- Buat tabel transaksi_detail jika belum ada
CREATE TABLE IF NOT EXISTS `transaksi_detail` (
  `id_transaksi_detail` int(11) NOT NULL AUTO_INCREMENT,
  `id_transaksi` int(11) NOT NULL,
  `id_produk` int(11) NOT NULL,
  `harga` decimal(15,2) NOT NULL,
  `qty` int(11) NOT NULL,
  `subtotal` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id_transaksi_detail`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
