<?php
// Script untuk update struktur tabel retur
$host = 'localhost';
$user = 'root';
$pass = '';
$db   = 'gerabah';

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "Connected successfully\n";

// Array of queries to run
$queries = [
    "ALTER TABLE `retur` ADD COLUMN `jenis_retur` ENUM('tukar_barang', 'refund_dana') DEFAULT 'tukar_barang' AFTER `id_customer`",
    "ALTER TABLE `retur` ADD COLUMN `bank_customer` VARCHAR(50) NULL AFTER `jenis_retur`",
    "ALTER TABLE `retur` ADD COLUMN `rekening_customer` VARCHAR(50) NULL AFTER `bank_customer`",
    "ALTER TABLE `retur` ADD COLUMN `an_customer` VARCHAR(100) NULL AFTER `rekening_customer`",
    "ALTER TABLE `retur` ADD COLUMN `nominal_refund` DECIMAL(15,2) DEFAULT 0 AFTER `an_customer`",
    "ALTER TABLE `retur` ADD COLUMN `bukti_transfer` VARCHAR(255) NULL AFTER `nominal_refund`"
];

foreach ($queries as $sql) {
    // Check if column exists first to avoid errors (simple check by running and catching error)
    // Or just run and ignore "Duplicate column" error
    if ($conn->query($sql) === TRUE) {
        echo "Query executed successfully: " . substr($sql, 0, 50) . "...\n";
    } else {
        echo "Error execution (might already exist): " . $conn->error . "\n";
    }
}

$conn->close();
echo "Database update process completed.\n";
?>